
<?php
session_start();

// Load DB if needed
require_once "DB.php";

function sanitize($text) {
    return strip_tags(trim($text));
}

$userMessage = sanitize($_POST['message'] ?? '');
$fileName = $_FILES['file']['name'] ?? null;

if (!$userMessage && !$fileName) {
    http_response_code(400);
    echo "No message or file provided.";
    exit;
}

// Optional: Handle uploaded file
if (!empty($_FILES['file']['tmp_name'])) {
    $uploadDir = __DIR__ . '/uploads/';
    if (!file_exists($uploadDir)) mkdir($uploadDir, 0755, true);
    $safeName = uniqid() . '_' . basename($fileName);
    move_uploaded_file($_FILES['file']['tmp_name'], $uploadDir . $safeName);
    $userMessage .= "\n[User uploaded file: $safeName]";
}

// Save to history
$_SESSION['history'][] = ['role' => 'user', 'content' => $userMessage];

// Call Mistral API (update with your own key and endpoint)
$apiKey = 'FjabhwMRoLquI4bxLkGpfylVlYpxFkfc';
$apiUrl = 'https://api.mistral.ai/v1/chat/completions';

$messages = $_SESSION['history'] ?? [];

$payload = json_encode([
    'model' => 'mistral-medium',
    'messages' => $messages,
    'temperature' => 0.7,
]);

$ch = curl_init($apiUrl);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $apiKey",
        "Content-Type: application/json"
    ],
    CURLOPT_POSTFIELDS => $payload,
    CURLOPT_TIMEOUT => 15
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode !== 200 || !$response) {
    http_response_code(500);
    echo "⚠️ Error getting response from Mistral.";
    exit;
}

$data = json_decode($response, true);
$reply = $data['choices'][0]['message']['content'] ?? '❓ No response.';

$_SESSION['history'][] = ['role' => 'assistant', 'content' => $reply];

echo trim($reply);
